import pyperclip
import re
import time

def extract_link_from_clipboard():
    clipboard_content = pyperclip.paste()
    # 更新正则表达式以匹配整个URL，但只捕获magnet部分
    pattern = r'https://keepshare\.org/[a-zA-Z0-9]+/(magnet:\?xt=urn:btih:[a-zA-Z0-9]+&dn=[\w%\-.\[\]]+)'
    match = re.search(pattern, clipboard_content)
    if match:
        # 提取并返回magnet部分
        extracted_link = match.group(1)
        return extracted_link
    else:
        print("No valid link found in clipboard content.")
        return None

def main():
    recent_value = ""
    while True:
        clipboard_value = extract_link_from_clipboard()
        if clipboard_value and clipboard_value != recent_value:
            recent_value = clipboard_value
            with open("miss-link.txt", "a") as file:
                file.write(clipboard_value + "\n")
            print("Link saved to miss-link.txt:", clipboard_value)
        time.sleep(1)

if __name__ == "__main__":
    main()
